// Function to animate the leaves
function animateLeaves() {
    const animatedElements = document.querySelectorAll(".animation");
    const scrollY = window.scrollY;

    animatedElements.forEach((element, index) => {
        let newTransform;
        const widerFactor = 40; // Increased for more noticeable movement

        if (element.classList.contains("animate-float")) {
            newTransform = Math.sin(scrollY / 100 + index) * widerFactor;
        } else if (element.classList.contains("animate-float-reverse")) {
            newTransform = Math.cos(scrollY / 100 + index) * widerFactor;
        }

        // Update the transform property
        element.style.transform = `translateY(${newTransform}px)`;
    });
}

// Add event listener for scroll
window.addEventListener("scroll", function() {
    requestAnimationFrame(animateLeaves);
});

// Initial animation
animateLeaves();

// Optionally, add periodic animation for subtle movement even when not scrolling
setInterval(animateLeaves, 100);