// Calcular altura
setInterval(() => {
  let height = document.body.scrollHeight;
  parent.postMessage({frameHeight: height}, '*');
}, 500);


var dotInfos = [
/* Informação dos pontos, usar o mesmo id do html e inserir aqui o titulo descriçao e endereço da img */
  {
    id: 'dot1',
    imgSrc: './imgs/detail-1.png',
    title: 'Bocal múltiplo',
    description: 'Mais agilidade.',
    },
  {
    id: 'dot2',
    imgSrc: './imgs/detail-2.png',
    title: 'Filtro hepa.',
    description: 'Retém impurezas do ar',
  },
  {
    id: 'dot3',
    imgSrc: './imgs/detail-3.png',
    title: 'Recipiente',
    description: 'Capacidade de 1.2L',
  },
  {
    id: 'dot4',
    imgSrc: './imgs/detail-4.png',
    title: 'Boca canto.',
    description: 'Mais praticidade.',
  }
  ,
  {
    id: 'dot5',
    imgSrc: './imgs/detail-5.png',
    title: 'Raste extensora.',
    description: 'Por ser compacto e desmontável, fica prático para guardar.',
  }
]

/* Bug fix for background img section-4 */ 
section4_image = document.getElementById('img_section4')
section4_image.style = `background-image: url('./imgs/imagem-secao-4.png');`

var infoBox = document.getElementById('info-box');
var dots = document.querySelectorAll('.dot');

/* Mostrar detalhes e posição de acordo com a posição da bolinha */ 
dots.forEach(function(dot) {
var detailInformation = dotInfos.find(function(dotInfo) {
  return dotInfo.id === dot.id;
})

/* Isso aqui é onde faz a amostragem das informações do hover */
dot.addEventListener('mouseover', function() {
    imgStyle = `width: 100%; height: 100%; object-fit: cover;`;
    var html = `
      <h2>${detailInformation.title}</h2>
      <p>${detailInformation.description}</p>
      <img src='${detailInformation.imgSrc}' alt='Imagem ${detailInformation.description}' style='${imgStyle}'>
    `;

    infoBox.innerHTML = html;
    infoBox.classList.remove('hidden');

    var infoBoxDinamicPosition = `
      top: ${dot.offsetTop - 150}px;
      left: ${dot.offsetLeft - -80}px;
    `
    infoBox.style = infoBoxDinamicPosition
  });
});


/* Tira o elemento da tela quando o mouse sair de cima da div infoBox */
infoBox.addEventListener('mouseleave', function() {
  infoBox.classList.add('hidden');
});

/* Adiciona os detalhes ao splider para mobile */
dotInfos.forEach(function(dot) {
  /* Criar elementos html */
  let liSlide = document.createElement('li');
  liSlide.className = 'splide__slide';
  let divCard = document.createElement('div');
  divCard.className = 'card';

  let imgCard = document.createElement('img');
  imgCard.className = 'card__image';
  imgCard.src = dot.imgSrc 
  imgCard.alt = dot.description 

  let divCardContent = document.createElement('div');
  divCardContent.className = 'card__content';

  let h3CardTitle = document.createElement('h3');
  h3CardTitle.className = 'card__title';
  h3CardTitle.textContent = dot.title 

  let divCardDescription = document.createElement('div');
  divCardDescription.className = 'card__description';

  let descriptioText = document.createElement('p');
  descriptioText.textContent = dot.description
  divCardDescription.appendChild(descriptioText);


  // Anexando os elementos criados
  divCard.appendChild(imgCard);
  divCardContent.appendChild(h3CardTitle);
  divCardContent.appendChild(divCardDescription);
  divCard.appendChild(divCardContent);
  liSlide.appendChild(divCard);

  // Obtendo o elemento ul existente e anexando o novo card
  let ulSplideList = document.getElementById('ul_splide');
  ulSplideList.appendChild(liSlide);
})


/* Splider */
document.addEventListener('DOMContentLoaded', function() {
  const splideConfig = {
  type: 'slide',
  perPage: 1,
  perMove: 1,
  gap: '15px',
  width: 'min(1200px, 100% - 60px)',
  breakpoints: {
  992: {
    perPage: 2,
  }, 
  480: {
    perPage: 1,
    rewind: true,
  },
  }
  };
  const splide = new Splide('.splide', splideConfig);
  splide.mount();
});

